/* Nachträgliches Hinzufügen von Contraints aller Art nach Tabellenerstellung.
Notwendig, wenn zum bsp. referenzierte Tabelle erst nach Fremdschlüssel-Tabelle erstellt wird.
*/

ALTER TABLE artcod ADD FOREIGN KEY (ac_ks)              REFERENCES ksv ON UPDATE CASCADE;

ALTER TABLE art ADD FOREIGN KEY (ak_ks)                 REFERENCES ksv ON UPDATE CASCADE;
ALTER TABLE art ADD FOREIGN KEY (ak_hersteller)         REFERENCES adk ON UPDATE CASCADE;
ALTER TABLE art ADD FOREIGN KEY (ak_kunde)              REFERENCES adk ON UPDATE CASCADE;
ALTER TABLE art ADD FOREIGN KEY (ak_lerkl_ad_krz)       REFERENCES adk ON UPDATE CASCADE;
ALTER TABLE art ADD FOREIGN KEY (ak_l_iso)              REFERENCES laender ON UPDATE CASCADE;

ALTER TABLE artinfo ADD FOREIGN KEY (ain_op_ix)         REFERENCES opl(op_ix) ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE artpr ADD FOREIGN KEY (pr_minr)             REFERENCES llv(ll_minr) ON UPDATE CASCADE;
ALTER TABLE artpr ADD FOREIGN KEY (pr_abix)             REFERENCES abk ON UPDATE CASCADE;

ALTER TABLE normzert ADD FOREIGN KEY (noz_qs_ident)     REFERENCES qsnorm ON UPDATE CASCADE;

ALTER TABLE anlstrprofil ADD FOREIGN KEY (ansp_op_ix)   REFERENCES opl;

ALTER TABLE auftg ADD FOREIGN KEY (ag_kanf_nr)          REFERENCES kundanfrage ON UPDATE CASCADE ON DELETE SET NULL;
ALTER TABLE auftg ADD FOREIGN KEY (ag_vtp_id)           REFERENCES vertrag_pos ON UPDATE CASCADE;
ALTER TABLE auftg ADD FOREIGN KEY (ag_q_nr)             REFERENCES qab ON UPDATE CASCADE;
ALTER TABLE auftg ADD FOREIGN KEY (ag_a2_id)            REFERENCES ab2 ON UPDATE CASCADE ON DELETE SET NULL; -- Bezug zum Arbeitsgang.

ALTER TABLE auftg ADD FOREIGN KEY (ag_bstat)            REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL;
ALTER TABLE auftg ADD FOREIGN KEY (ag_bstat1)           REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL;
ALTER TABLE auftg ADD FOREIGN KEY (ag_bstat2)           REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL;
ALTER TABLE auftg ADD FOREIGN KEY (ag_kanfwsk_wsk)      REFERENCES kanfwsk ON UPDATE CASCADE;
ALTER TABLE auftg ADD FOREIGN KEY (ag_absgrup)          REFERENCES kundabs ON UPDATE CASCADE;

ALTER TABLE bdea  ADD FOREIGN KEY (ba_ix)               REFERENCES abk ON UPDATE CASCADE;
ALTER TABLE anfart ADD FOREIGN KEY (aArt_ab_ix)         REFERENCES abk ON UPDATE CASCADE;

--ALTER TABLE rahmenlieferant ADD FOREIGN KEY(a2rh_vtr_nr) REFERENCES vertrag ON UPDATE CASCADE;

ALTER TABLE kundanfrage ADD FOREIGN KEY (kanf_ld_id)    REFERENCES ldsdok; -- Einkauf welche sich auf die Serviceanfrage bezieht

ALTER TABLE werkzeugausg ADD FOREIGN KEY (awz_an_nr)    REFERENCES anl ON UPDATE CASCADE;

ALTER TABLE anfart ADD FOREIGN KEY (aart_a2_id)         REFERENCES ab2 ON UPDATE CASCADE;

ALTER TABLE vertrag ADD FOREIGN KEY (vtr_dokunr)        REFERENCES auftgdokutxt ON UPDATE CASCADE;
ALTER TABLE vertrag ADD FOREIGN KEY (vtr_apint)         REFERENCES llv (ll_db_usename) ON UPDATE CASCADE; -- Ansprechpartner Intern

ALTER TABLE vertrag_pos ADD FOREIGN KEY (vtp_ks)        REFERENCES ksv ON UPDATE CASCADE;

ALTER TABLE vertragsanlagen ADD FOREIGN KEY (vta_atd_dokunr) REFERENCES auftgdokutxt ON UPDATE CASCADE;

ALTER TABLE auftgdokzahlplan ADD FOREIGN KEY (azp_be_bnr) REFERENCES belkopf ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE lag ADD FOREIGN KEY (lg_w_wen)              REFERENCES wendat ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE lifsch ADD FOREIGN KEY (l_ab_ix)            REFERENCES abk ON UPDATE CASCADE;
-- ALTER TABLE lifsch ADD FOREIGN KEY (l_qab_awrid)        REFERENCES auswlogrueck; Entfällt wegen auswärtsumsetzung
ALTER TABLE lifsch ADD FOREIGN KEY (l_qab)              REFERENCES qab;
ALTER TABLE lifsch ADD FOREIGN KEY (l_belp_id)          REFERENCES belegpos ON UPDATE CASCADE ON DELETE SET NULL;
-- ALTER TABLE lifsch ADD FOREIGN KEY (l_qab_ldid)         REFERENCES ldsdok; -- Entfällt wegen Auswärtsumsetzung
ALTER TABLE lifsch ADD FOREIGN KEY (l_bz_id)            REFERENCES belzeil_auftg_lif(bz_id) ON UPDATE CASCADE; -- Referenz auf Rechnung, siehe #8093

ALTER TABLE wendat ADD FOREIGN KEY (w_q_nr)             REFERENCES qab ON UPDATE CASCADE ON DELETE SET NULL;
ALTER TABLE wendat ADD FOREIGN KEY (w_auss_asg_id)      REFERENCES bdea_ausschussgruende ON UPDATE CASCADE;
ALTER TABLE wendat ADD FOREIGN KEY (w_a2_id)            REFERENCES ab2 ON UPDATE CASCADE;

ALTER TABLE auftgdokutxt ADD FOREIGN KEY (atd_apint)    REFERENCES llv (ll_db_usename) ON UPDATE CASCADE;
ALTER TABLE ldsdokdokutxt ADD FOREIGN KEY (ltd_apint)   REFERENCES llv (ll_db_usename) ON UPDATE CASCADE;
ALTER TABLE belkopf ADD FOREIGN KEY (be_apint)          REFERENCES llv (ll_db_usename) ON UPDATE CASCADE;
ALTER TABLE belmahn ADD FOREIGN KEY (bm_apint)          REFERENCES llv (ll_db_usename) ON UPDATE CASCADE;

ALTER TABLE belzeil_grund ADD FOREIGN KEY (bz_belp_id)  REFERENCES belegpos ON UPDATE CASCADE;
ALTER TABLE belzeil_auftg_lif ADD CONSTRAINT bz_belp_id FOREIGN KEY (bz_belp_id) REFERENCES belegpos ON UPDATE CASCADE;

ALTER TABLE cocpos ADD FOREIGN KEY (cocp_belp_id)       REFERENCES belegpos;

ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_ldid) REFERENCES ldsdok ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_wwen) REFERENCES wendat ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_agid) REFERENCES auftg  ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_lnr)  REFERENCES lifsch ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_weknr) REFERENCES wareneingangskontrolle ON UPDATE CASCADE ON DELETE CASCADE;
-- ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_aw_id) REFERENCES auswlog ON UPDATE CASCADE ON DELETE CASCADE;
-- ALTER TABLE artpruefungTest ADD FOREIGN KEY (aprt_awr_id) REFERENCES auswlogrueck ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE recnogroup ADD FOREIGN KEY (reg_ac_n)       REFERENCES artcod ON UPDATE CASCADE;

-- ALTER TABLE recnokeyword ADD FOREIGN KEY (r_reg_pname)  REFERENCES recnogroup(reg_pname) ON UPDATE CASCADE; -- entfernt, #7069
-- ALTER TABLE RecnoEnums ADD FOREIGN KEY (rege_reg_pname) REFERENCES recnogroup(reg_pname) ON UPDATE CASCADE; -- entfernt und durch Trigger manuell implementiert, da Eindeutigkeit in Vorgabe wegen AC nicht mehr gegeben, #7069

ALTER TABLE llv_members ADD FOREIGN KEY (llm_minr) REFERENCES llv ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE ldsdok ADD FOREIGN KEY (ld_rhl_nr)          REFERENCES rahmenlieferant ON UPDATE CASCADE;
ALTER TABLE ldsdok ADD FOREIGN KEY (ld_a2_id)           REFERENCES ab2;
ALTER TABLE ldsdok ADD FOREIGN KEY (ld_vtp_id)          REFERENCES vertrag_pos ON UPDATE CASCADE;
ALTER TABLE ldsdok ADD FOREIGN KEY (ld_q_nr)            REFERENCES qab ON UPDATE CASCADE;
ALTER TABLE ldsdok ADD FOREIGN KEY (ld_aAng_id)         REFERENCES anfangebot ON UPDATE CASCADE;

ALTER TABLE ldsauftg ADD FOREIGN KEY (la_bvp_id)        REFERENCES BestVorschlagPos ON UPDATE CASCADE ON DELETE SET NULL; -- la_bvp_id NOT NULL AND la_ld_id NOT NULL per Trigger
CREATE UNIQUE INDEX ldsauftg_bvp_id_ag_id ON ldsauftg(la_bvp_id, COALESCE(la_ag_id, -1), COALESCE(la_bap_id, -1)) WHERE la_bvp_id IS NOT NULL; -- Bezug zur Bestellvorschlagspos kann NULL sein, wenn nur Bestellbezug da ist.

ALTER TABLE rm ADD FOREIGN KEY (r_belp_id)              REFERENCES belegpos ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE eingrechzahlung ADD FOREIGN KEY (belzlg_sepa_id) REFERENCES sepaTransaktion ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE NormZert ADD FOREIGN KEY (noz_apint)        REFERENCES llv (ll_db_usename) ON UPDATE CASCADE;
ALTER TABLE NormZert ALTER COLUMN noz_apint SET DEFAULT tsystem.current_user_ll_db_usename();

ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_mo)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_di)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_mi)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_do)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_fr)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_sa)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_standplan_so)       REFERENCES tplan ON UPDATE CASCADE;
ALTER TABLE llv ADD FOREIGN KEY (ll_stand_ab_id)        REFERENCES bdeabgruende;

ALTER TABLE oplpm_data ADD FOREIGN KEY (pm_a2_id)       REFERENCES ab2 ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE oplpm_mw   ADD FOREIGN KEY (mw_pruefer)     REFERENCES llv (ll_db_usename) ON UPDATE CASCADE; --(DS 2017-02-01) kein OnDelete, sonst gehen relvante Daten verloren!

-- ALTER TABLE BestVorschlagPos ADD FOREIGN KEY (bvp_db_usename) REFERENCES llv (ll_db_usename) ON UPDATE CASCADE ON DELETE CASCADE; -- nicht mehr wegen https://redmine.prodat-sql.de/issues/13357
ALTER TABLE BestVorschlagPos ADD FOREIGN KEY (bvp_aArt_id) REFERENCES anfArt ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE epreisstaffel ADD FOREIGN KEY (est_aArt_id) REFERENCES anfArt ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE epreisstaffel ADD FOREIGN KEY (est_aAng_id) REFERENCES anfangebot ON UPDATE CASCADE ON DELETE CASCADE;

-- Bugfix: Belegpos ..._bstat Constraints auskommentiert, da Konflikte mit freier Eingabe im Auftrag bei der Übernahme in Lieferschein (bei Loll passiert, LG)
-- ALTER TABLE belegpos ADD FOREIGN KEY (belp_bstat)       REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL;
-- ALTER TABLE belegpos ADD FOREIGN KEY (belp_bstat1)      REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL;
-- ALTER TABLE belegpos ADD FOREIGN KEY (belp_bstat2)      REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE epreiskat ADD FOREIGN KEY( ek_awk_bez ) REFERENCES auswkategorie ON UPDATE CASCADE ON DELETE CASCADE;


-- Foreign Key auf die Arbeitsgänge
ALTER TABLE ncp_o2_a2_ksv ADD FOREIGN KEY ( ncpoak_a2_id ) REFERENCES ab2( a2_id ) ON UPDATE CASCADE ON DELETE CASCADE;


ALTER TABLE mapsernr_mw ADD FOREIGN KEY ( msmw_abix ) REFERENCES abk ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE ab2_wkstplan DROP CONSTRAINT IF EXISTS ab2_wkstplan_a2w_resource_id_main_fix_fkey;
ALTER TABLE ab2_wkstplan DROP CONSTRAINT IF EXISTS ab2_wkstplan_a2w_resource_id_main_fix_fkey1;
ALTER TABLE ab2_wkstplan ADD CONSTRAINT ab2_wkstplan_a2w_resource_id_main_fix_fkey FOREIGN KEY ( a2w_resource_id_main_terminated ) REFERENCES scheduling.resource ON DELETE SET null;
ALTER TABLE ab2_wkstplan DROP CONSTRAINT IF EXISTS ab2_wkstplan_a2w_resource_id_main_terminated_fkey;
ALTER TABLE ab2_wkstplan DROP CONSTRAINT IF EXISTS ab2_wkstplan_a2w_resource_id_main_terminated_fkey2;
ALTER TABLE ab2_wkstplan ADD CONSTRAINT ab2_wkstplan_a2w_resource_id_main_terminated_fkey FOREIGN KEY ( a2w_resource_id_main_fix ) REFERENCES scheduling.resource ON DELETE SET null;